// Flac.cpp: implementation of the CFlac class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Flac.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern "C" long _ftol(double);
extern "C" long _ftol2(double dblSource) {return _ftol(dblSource);}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

FLAC__StreamDecoderWriteStatus writeProc(const FLAC__FileDecoder* pDecoder,const FLAC__Frame* pFrame,const FLAC__int32 * const buffer[],void* clientData)
{
	CFlac* pFlac=(CFlac*)clientData;
	pFlac->m_FrameSize=pFrame->header.blocksize;
	pFlac->m_CurrentPos+=pFlac->m_FrameSize;
	if(pFlac->m_bError)
		return FLAC__STREAM_DECODER_WRITE_STATUS_ABORT;
	else
		return FLAC__STREAM_DECODER_WRITE_STATUS_CONTINUE;
}

void metadataProc(const FLAC__FileDecoder* pDecoder,const FLAC__StreamMetadata* metadata, void* clientData)
{
	CFlac* pFlac=(CFlac*)clientData;
	pFlac->m_Samples=metadata->data.stream_info.total_samples;
}

void errorProc(const FLAC__FileDecoder* pDecoder, FLAC__StreamDecoderErrorStatus status, void* clientData)
{
	CFlac* pFlac=(CFlac*)clientData;
	switch(status)
	{
	case FLAC__STREAM_DECODER_ERROR_STATUS_LOST_SYNC:
		pFlac->m_Error="ERROR_LOST_SYNC";
		break;
	case FLAC__STREAM_DECODER_ERROR_STATUS_BAD_HEADER:
		pFlac->m_Error="ERROR_BAD_HEADER";
		break;
	case FLAC__STREAM_DECODER_ERROR_STATUS_FRAME_CRC_MISMATCH:
		pFlac->m_Error="ERROR_FRAME_CRC_MISMATCH";
	}
	pFlac->GetErrorPos();
	pFlac->m_bError=1;
}

CFlac::CFlac()
{
	m_Loaded=0;
	m_FrameSize=0;
	m_Samples=0;
	m_CurrentPos=0;
	m_bError=0;
	m_Error="";
	m_pDecoder=FLAC__file_decoder_new();
}

CFlac::~CFlac()
{
	CloseStream();
	if(m_pDecoder)
		FLAC__file_decoder_delete(m_pDecoder);
}

BOOL CFlac::OpenStream(CString filepath, DWORD startpos, BOOL fp, BOOL skipsilence)
{
	if(m_pDecoder)
	{
		CloseStream();
		FLAC__file_decoder_set_filename(m_pDecoder,filepath);
		FLAC__file_decoder_set_client_data(m_pDecoder,this);
		FLAC__file_decoder_set_write_callback(m_pDecoder,writeProc);
		FLAC__file_decoder_set_metadata_callback(m_pDecoder,metadataProc);
		FLAC__file_decoder_set_error_callback(m_pDecoder,errorProc);
		FLAC__file_decoder_set_metadata_ignore_all(m_pDecoder);
		FLAC__file_decoder_set_metadata_respond(m_pDecoder,FLAC__METADATA_TYPE_STREAMINFO);
		FLAC__file_decoder_set_md5_checking(m_pDecoder,1);
		m_State=FLAC__file_decoder_init(m_pDecoder);
		if(m_State==FLAC__FILE_DECODER_OK)
		{
			FLAC__file_decoder_process_until_end_of_metadata(m_pDecoder);
			m_State=FLAC__file_decoder_get_state(m_pDecoder);
			if(m_State==FLAC__FILE_DECODER_OK)
			{
				m_Loaded=1;
				return 1;
			}
			else
			{
				FLAC__file_decoder_finish(m_pDecoder);
				GetStateError();
			}
		}
		else
			GetStateError();
	}
	return 0;
}

void CFlac::CloseStream()
{
	if(m_Loaded)
	{
		FLAC__file_decoder_finish(m_pDecoder);
		m_Loaded=0;
	}
	m_FrameSize=0;
	m_Samples=0;
	m_CurrentPos=0;
	m_bError=0;
	m_Error="";
}

long CFlac::ReadChunk()
{
	FLAC__file_decoder_process_single(m_pDecoder);
	m_State=FLAC__file_decoder_get_state(m_pDecoder);
	switch(m_State)
	{
	case FLAC__FILE_DECODER_OK:
		break;
	case FLAC__FILE_DECODER_END_OF_FILE:
		if(FLAC__file_decoder_finish(m_pDecoder))
			m_FrameSize=0;
		else
		{
			m_FrameSize=-1;
			m_Error="ERROR_MD5_CHECK";
		}
		m_Loaded=0;
		break;
	default:
		m_FrameSize=-1;
		GetStateError();
	}
	return m_FrameSize;
}

void CFlac::GetStateError()
{
	if(m_Error.GetLength())
		return;
	m_Error=FLAC__file_decoder_get_resolved_state_string(m_pDecoder);
}

void CFlac::GetErrorPos()
{
	if(m_Error.IsEmpty()||!m_pDecoder)
		return;
	unsigned int freq=FLAC__file_decoder_get_sample_rate(m_pDecoder);
	if(freq)
	{
		int seconds=(int)(m_CurrentPos/freq);
		char buffer[16]="";
		itoa(seconds/60,buffer,10);
		m_Error+=" @ ";
		m_Error+=buffer;
		m_Error+="m ";
		itoa(seconds%60,buffer,10);
		m_Error+=buffer;
		m_Error+="s";
	}
}
