// Flac.h: interface for the CFlac class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FLAC_H__6D7F6375_F8DB_4A6F_821F_1904D719CADD__INCLUDED_)
#define AFX_FLAC_H__6D7F6375_F8DB_4A6F_821F_1904D719CADD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <flac/all.h>

#define FLACSIZE	FLAC__MAX_BLOCK_SIZE*4
#define RMS_WINDOW	50

class CFlac  
{
public:
	CFlac();
	virtual ~CFlac();
	__int64 m_Samples;
	__int64 m_CurrentPos;
	CString m_Error;
	BOOL m_bError;
	long m_FrameSize;

	BOOL OpenStream(CString filepath, DWORD startpos=0, BOOL fp=0, BOOL skipsilence=0);
	void CloseStream();
	long ReadChunk();
	void GetErrorPos();

protected:
	BOOL m_Loaded;
	FLAC__FileDecoder* m_pDecoder;
	FLAC__FileDecoderState m_State;

	void GetStateError();
};

#endif // !defined(AFX_FLAC_H__6D7F6375_F8DB_4A6F_821F_1904D719CADD__INCLUDED_)
