// Vorbis.cpp: implementation of the CVorbis class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Vorbis.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern "C" long _ftol(double);
extern "C" long _ftol2(double dblSource) {return _ftol(dblSource);}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVorbis::CVorbis()
{
	m_hVorbis=0;
}

CVorbis::~CVorbis()
{
	CloseStream();
}

void CVorbis::CloseStream()
{
	m_PCMTotal=0;
	m_Error="";
	if(m_hVorbis)
	{
		ov_clear(&m_VorbisFile);
		m_hVorbis=0;
	}
}

BOOL CVorbis::OpenStream(CString filepath)
{
	CloseStream();
	TCHAR buffer[MAX_PATH]=_T("");
	lstrcpyn(buffer,filepath,MAX_PATH);
	m_hVorbis=_tfopen(buffer,_T("rb"));
	if(m_hVorbis)
	{
		int error=ov_open(m_hVorbis,&m_VorbisFile,0,0);
		if(error)
		{
			switch(error)
			{
			case OV_EREAD:
				m_Error="OV_EREAD";
				break;
			case OV_ENOTVORBIS:
				m_Error="OV_ENOTVORBIS";
				break;
			case OV_EVERSION:
				m_Error="OV_EVERSION";
				break;
			case OV_EBADHEADER:
				m_Error="OV_EBADHEADER";
				break;
			case OV_EFAULT:
				m_Error="OV_EFAULT";
				break;
			default:
				m_Error="UNKNOWN";
			}
			fclose(m_hVorbis);
			m_hVorbis=0;
		}
		else
		{
			m_PCMTotal=ov_pcm_total(&m_VorbisFile,-1);
			return 1;
		}
	}
	else
		m_Error="OPENFILE";
	return 0;
}

long CVorbis::ReadChunk()
{
	m_dwRead=ov_read_float(&m_VorbisFile,&m_pFloat,VORBIS_BUFFERSIZE/4,&m_VorbisStream);
	switch(m_dwRead)
	{
	case OV_HOLE:
		m_Error="OV_HOLE @ ";
		break;
	case OV_EBADLINK:
		m_Error="OV_EBADLINK @ ";
		break;
	case 0:
		if(!m_VorbisFile.os.e_o_s)
		{
			m_Error="TRUNCATED @ ";
			m_dwRead=-1;
			break;
		}
	default:
		return m_dwRead;
	}
	char buffer[16]="";
	int seconds=(int)ov_time_tell(&m_VorbisFile);
	itoa(seconds/60,buffer,10);
	m_Error+=buffer;
	m_Error+="m ";
	if(seconds%60<10)
		m_Error+="0";
	itoa(seconds%60,buffer,10);
	m_Error+=buffer;
	m_Error+="s";
	return m_dwRead;
}
