// tempDlg.cpp : implementation file
//

#include "stdafx.h"
#include "temp.h"
#include "tempDlg.h"
#include "Vorbis.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTempDlg dialog

UINT ScanFunc(LPVOID lpParam)
{
	CTempDlg* pDlg=(CTempDlg*)lpParam;
	pDlg->m_bScanning=1;
	CVorbis vorbis;
	CString filepath="";
	CString status="";
	CString errorstr="";
	char buffer[8]="";
	int bytesread,bytestotal;
	int errorcount=0;
	int filecount=0;
	POSITION pos=pDlg->m_FileList.GetHeadPosition();
	pDlg->SetStatus(status);
	pDlg->SetButtons();
	while(pos&&pDlg->m_bContinue)
	{
		filecount++;
		filepath=pDlg->m_FileList.GetNext(pos);
		if(status.GetLength())
			status+="\r\n";
		itoa(filecount,buffer,10);
		status+="[";
		status+=buffer;
		status+="/";
		itoa(pDlg->m_FileList.GetCount(),buffer,10);
		status+=buffer;
		status+="]\t";
		status+=filepath;
		status+="...";
		if(vorbis.OpenStream(filepath))
		{
			bytestotal=0;
			bytesread=1;
			pDlg->SetProgress((int)vorbis.m_PCMTotal,1);
			pDlg->SetStatus(status);
			while(bytesread&&pDlg->m_bContinue)
			{
				bytesread=vorbis.ReadChunk();
				if(bytesread<0)
				{
					errorcount++;
					status+="ERROR (";
					status+=vorbis.m_Error;
					status+=")";
					bytesread=0;
					if(errorstr.GetLength())
						errorstr+=",";
					itoa(filecount,buffer,10);
					errorstr+=buffer;
				}
				else
				{
					bytestotal+=bytesread;
					if(!bytesread)
						status+="OK";
				}
				pDlg->SetProgress(bytestotal);
				WaitForSingleObject(pDlg->m_hPaused,INFINITE);
			}
			pDlg->SetStatus(status);
		}
		else
		{
			errorcount++;
			status+="ERROR (";
			status+=vorbis.m_Error;
			status+=")";
			if(errorstr.GetLength())
				errorstr+=",";
			itoa(filecount,buffer,10);
			errorstr+=buffer;
		}
	}
	if(status.GetLength())
		status+="\r\n";
	itoa(filecount,buffer,10);
	status+=buffer;
	status+=" files, ";
	itoa(errorcount,buffer,10);
	status+=buffer;
	status+=" errors";
	if(errorstr.GetLength())
	{
		status+=" [";
		status+=errorstr;
		status+="]";
	}
	pDlg->SetStatus(status);
	pDlg->m_bScanning=0;
	pDlg->SetProgress(0);
	pDlg->SetButtons();
	return 0;
}

CTempDlg::CTempDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTempDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTempDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bInit=0;
	m_pWnd=0;
}

void CTempDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTempDlg)
	DDX_Control(pDX, IDOK, m_OK);
	DDX_Control(pDX, IDCANCEL, m_Cancel);
	DDX_Control(pDX, IDC_FOLDER, m_Folder);
	DDX_Control(pDX, IDC_BROWSE, m_Browse);
	DDX_Control(pDX, IDC_STATUS, m_Status);
	DDX_Control(pDX, IDC_PROGRESS, m_Progress);
	//}}AFX_DATA_MAP
}

void CTempDlg::SetButtons()
{
	CButton* pButton=(CButton*)GetDlgItem(IDOK);
	if(m_bScanning)
	{
		if(WaitForSingleObject(m_hPaused,0)==WAIT_OBJECT_0)
			pButton->SetWindowText(_T("Pause"));
		else
			pButton->SetWindowText(_T("Continue"));
	}
	else
		pButton->SetWindowText(_T("Start"));
	pButton=(CButton*)GetDlgItem(IDCANCEL);
	if(m_bScanning)
		pButton->SetWindowText(_T("Cancel"));
	else
		pButton->SetWindowText(_T("Close"));
}

void CTempDlg::SetStatus(CString &status)
{
	SetDlgItemText(IDC_STATUS,status);
	m_Status.LineScroll(m_Status.GetLineCount());
}

void CTempDlg::SetProgress(int pos, BOOL set)
{
	if(set)
	{
		m_Progress.SetRange32(0,pos);
		m_Progress.SetPos(0);
	}
	else
		m_Progress.SetPos(pos);
}

void CTempDlg::SearchFolder(CString folder)
{
	BOOL found=0;
	CFileFind fileFind;
	if(folder.GetLength())
	{
		if(folder.GetAt(folder.GetLength()-1)=='\\')
			found=fileFind.FindFile(folder+"*.*");
		else
			found=fileFind.FindFile(folder+"\\*.*");
	}
	else
		return;
	while(found)
	{
		found=fileFind.FindNextFile();
		if(fileFind.IsDirectory())
		{
			if(fileFind.GetFileName().GetAt(0)!='.')
				SearchFolder(fileFind.GetFilePath());
		}
		else
		{
			if(CheckExtension(fileFind.GetFilePath()))
				m_FileList.AddTail(fileFind.GetFilePath());
		}
	}
}

BOOL CTempDlg::CheckExtension(CString filename)
{
	CString extension;
	int index=filename.ReverseFind('.');
	if(index>=0)
		extension=filename.Mid(index+1);
	else
		return 0;
	if(!extension.CompareNoCase(_T("ogg")))
		return 1;
	return 0;
}

BEGIN_MESSAGE_MAP(CTempDlg, CDialog)
	//{{AFX_MSG_MAP(CTempDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_WM_DROPFILES()
	ON_WM_GETMINMAXINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTempDlg message handlers

BOOL CTempDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_Status.SetTabStops(40);
	m_hPaused=CreateEvent(0,1,1,0);
	m_bScanning=m_bContinue=0;
	DragAcceptFiles(1);
	if(m_CmdLine.GetLength())
	{
		m_CmdLine.Remove('"');
		if(GetFileAttributes(m_CmdLine)&FILE_ATTRIBUTE_DIRECTORY)
			SearchFolder(m_CmdLine);
		else
		{
			if(CheckExtension(m_CmdLine))
				m_FileList.AddTail(m_CmdLine);
		}
		if(m_FileList.GetCount()&&!m_bScanning)
		{
			m_bContinue=1;
			CWinThread* pThread=AfxBeginThread(ScanFunc,this);
		}
	}
	GetWindowRect(&m_DlgRect);
	m_bInit=1;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTempDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTempDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTempDlg::OnBrowse() 
{
	BROWSEINFO browseInfo;
	ZeroMemory(&browseInfo,sizeof(BROWSEINFO));
	TCHAR buffer[MAX_PATH]=_T("");
	CString tempStr="Choose a folder to scan for ogg files:";
	browseInfo.hwndOwner=this->GetSafeHwnd();
	browseInfo.pszDisplayName=buffer;
	browseInfo.lpszTitle=tempStr;
	browseInfo.ulFlags=BIF_EDITBOX;
	LPITEMIDLIST idList=SHBrowseForFolder(&browseInfo);
	if(idList&&SHGetPathFromIDList(idList,buffer))
	{
		tempStr=buffer;
		if(tempStr.GetLength())
		{
			SetDlgItemText(IDC_FOLDER,tempStr);
			CEdit* pEdit=(CEdit*)GetDlgItem(IDC_FOLDER);
			int length=pEdit->LineLength();
			pEdit->SetSel(length-1,length-1);
		}
	}
	LPMALLOC pMalloc;
	if(SHGetMalloc(&pMalloc)==NOERROR)
	{
		pMalloc->Free(idList);
		pMalloc->Release();
	}
}

void CTempDlg::OnOK() 
{
	if(m_bScanning)
	{
		if(WaitForSingleObject(m_hPaused,0)==WAIT_OBJECT_0)
			ResetEvent(m_hPaused);
		else
			SetEvent(m_hPaused);
		SetButtons();
	}
	else
	{
		CString tempstr;
		GetDlgItemText(IDC_FOLDER,tempstr);
		if(tempstr.GetLength())
		{
			m_FileList.RemoveAll();
			HCURSOR oldCursor=GetCursor();
			SetCursor(LoadCursor(0,IDC_WAIT));
			SearchFolder(tempstr);
			SetCursor(oldCursor);
			m_bContinue=1;
			CWinThread* pThread=AfxBeginThread(ScanFunc,this);
		}
	}
//	CDialog::OnOK();
}

void CTempDlg::OnCancel() 
{
	if(m_bScanning)
	{
		SetEvent(m_hPaused);
		m_bContinue=0;
	}
	else
		CDialog::OnCancel();
}

void CTempDlg::OnDropFiles(HDROP hDropInfo)
{
	CString tempstr="";
	TCHAR buffer[512]=_T("");
	UINT filecount=DragQueryFile(hDropInfo,0xffffffff,buffer,0);
	if(!m_bScanning)
		m_FileList.RemoveAll();
	HCURSOR oldCursor=GetCursor();
	SetCursor(LoadCursor(0,IDC_WAIT));	
	for(UINT index=0;index<filecount;index++)
	{
		DragQueryFile(hDropInfo,index,buffer,512);
		tempstr=buffer;
		if(GetFileAttributes(tempstr)&FILE_ATTRIBUTE_DIRECTORY)
			SearchFolder(tempstr);
		else
		{
			if(CheckExtension(tempstr))
				m_FileList.AddTail(tempstr);
		}
	}
	if(m_FileList.GetCount()&&!m_bScanning)
	{
		m_bContinue=1;
		CWinThread* pThread=AfxBeginThread(ScanFunc,this);
	}
	SetCursor(oldCursor);
}

void CTempDlg::OnGetMinMaxInfo(MINMAXINFO *lpMMI)
{
	lpMMI->ptMinTrackSize.x=320;
	lpMMI->ptMinTrackSize.y=240;
}

void CTempDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	if(m_bInit&&nType!=SIZE_MINIMIZED)
	{
		CRect a,b;
		GetWindowRect(&a);
		int x=a.Width()-m_DlgRect.Width();
		int y=a.Height()-m_DlgRect.Height();

		m_Folder.GetWindowRect(&b);
		ScreenToClient(&b);
		b.right+=x;
		m_Folder.MoveWindow(&b,0);

		m_Browse.GetWindowRect(&b);
		ScreenToClient(&b);
		b.left+=x; b.right+=x;
		m_Browse.MoveWindow(&b,0);

		m_Status.GetWindowRect(&b);
		ScreenToClient(&b);
		b.right+=x; b.bottom+=y;
		m_Status.MoveWindow(&b,0);

		m_Progress.GetWindowRect(&b);
		ScreenToClient(&b);
		b.right+=x; b.top+=y; b.bottom+=y;
		m_Progress.MoveWindow(&b,0);

		m_OK.GetWindowRect(&b);
		ScreenToClient(&b);
		b.left+=x; b.right+=x; b.top+=y; b.bottom+=y;
		m_OK.MoveWindow(&b,0);

		m_Cancel.GetWindowRect(&b);
		ScreenToClient(&b);
		b.left+=x; b.right+=x; b.top+=y; b.bottom+=y;
		m_Cancel.MoveWindow(&b,0);

		m_DlgRect=a;

		RedrawWindow();
	}
}
